/*******************************************************************************

LightroomModelsInit.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2014 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

/*!
	\file LightroomModelsInit.h

	\brief \c LightroomModelsInit provides API for initing the Lightroom Client models.
*/

#ifndef LightroomModelsInit_h
#define LightroomModelsInit_h

	// WF/core
#include <WFCore/WFApiDefs.h>

	// kernel
#include <AgKernel/AgLuaState.h>


//==============================================================================
/*!
	\brief Initializes LightroomModels core library.

	Call once, before any other functions in LightroomModels.
	Any subsequent calls are ignored. After this call, you can initialize all other modules.
*/

WF_API void LightroomModels_initialize( void );

#endif
