/*******************************************************************************

KSDateImp.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2007 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifndef KSDateImp_h
#define KSDateImp_h

#define SECS_BETWEEN_REF_AND_EPOCH_DATES	978307200L	// seconds btw 1970-01-01 and 2001-01-01 = 31 years, plus 8 leap days

//------------------------------------------------------------------------------

enum KSDateFormatterType {
	Iso8601InputFormatter,
	Iso8601UtcInputFormatter,
	DiffInDaysInputFormatter,
	PoliteDateOutputFormatter,
	Iso8601WithTimezoneFormatter,
	PoliteMonthOutputFormatter,
	PoliteYearOutputFormatter,
};

//------------------------------------------------------------------------------

double KSDateImp_timeNowForAnimation( void );

//------------------------------------------------------------------------------

#if IOS_ENV || MAC_ENV

NSDateFormatter* registerOrRetrieveDateFormatter( lua_State* L, enum KSDateFormatterType type );

	// NSDateFormatters are cached lazily in thread-local storage via the Lua registry.
	// Similarly-configured NSDateFormatter instances can be shared among multiple
	// clients on the same thread with this mechanism. Using registerOrRetrieveDateFormatter
	// ensures thread safety, while also maintaining the performance benefits of
	// caching NSDateFormatters and avoiding locks.

#elif WIN_ENV || WINRT_ENV

#include "windows.h"
//using namespace Windows::Foundation;

	// FIXME [erwright 2012-02-09]: Implement registerOrRetrieveDateFormatter for Windows.

	BOOL FileTimeToLocalSystemTime( const FILETIME* fileTime, SYSTEMTIME* sysTime );
	double fileTimeToSeconds( const FILETIME& fileTime, bool inMilliSeconds);
	void secondsToFileTime( double seconds, FILETIME& fileTime );
	int diffFileTimes( const FILETIME& ft1, const FILETIME& ft2, LPSYSTEMTIME diffTime );
		/**< return value is like normal comparison, ft1 < ft2 returns -1, ft1 == ft2 returns 0 */
		/**< ft1 > ft2 returns 1, diffTime is the absolute value of the time diff. */

#endif

//------------------------------------------------------------------------------

#endif // KSDateImp_h
