/*******************************************************************************

KSDebugMacros.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2010 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

********************************************************************************

Utility macros for common debug operations.

*******************************************************************************/

#ifndef KSDebugMacros_h
#define KSDebugMacros_h

	// core/utils
#include "KSMacros.h"


//==============================================================================

#pragma mark Timing operations

//------------------------------------------------------------------------------
/*
	Time an operation with debug output.
	
	Usage:
	
		KSBeginTimedOperation( myTaskName );	// myTaskName will name a variable
		
		// do stuff
		
		KSEndTimedOperationWithLog( varName );	// Always logs the time with the name varName referenced in the log
		
	Or:
	
		KSBeginTimedOperation( myTaskName );	// myTaskName will name a variable
		
		// do stuff
		
		KSEndTimedOperationWithLog_unlessFasterThan( varName, maxTimeAlloted );
				// Logs the time with the name varName referenced in the log if it meets or exceeds maxTimeAlloted
*/

//------------------------------------------------------------------------------

#define USE_TIMED_OPERATION_WATCHDOGS KS_PERFORMANCE_TESTING


#if USE_TIMED_OPERATION_WATCHDOGS

#define KSBeginTimedOperation( varName ) CFAbsoluteTime varName = CACurrentMediaTime()

#define KSEndTimedOperationWithLog_unlessFasterThan( varName, maxTimeAllotted ) \
	KSStatementBlock( \
		CFAbsoluteTime endTime = CACurrentMediaTime(); \
		CFTimeInterval elapsedTime = endTime - varName; \
		if( elapsedTime >= ( maxTimeAllotted ) ) { \
			NSLog( @"Operation %s took %.3f seconds (%s:%d)", #varName, elapsedTime, __FILE__, __LINE__ ); \
		} \
	)
	
#define KSEndTimedOperationWithLog( varName ) KSEndTimedOperationWithLog_unlessFasterThan( varName, 0 )

#else

#define KSBeginTimedOperation( varName )

#define KSEndTimedOperationWithLog_unlessFasterThan( varName, maxTimeAllotted )
	
#define KSEndTimedOperationWithLog( varName )

#endif

//------------------------------------------------------------------------------

#endif
