/*******************************************************************************

KSLuaInitSequence.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2010 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifndef KSLuaInitSequence_h
#define KSLuaInitSequence_h

	// Lua
#include <AgKernel/lua.h>
#include <AgKernel/lauxlib.h>

#include "WFApiDefs.h"


//==============================================================================
/*
	This file allows the application to customize portions of the standard
	Lua initialization sequence for Lua universes created via KSLuaUniverse.
*/

//------------------------------------------------------------------------------

WF_API void ksl_addPackageNamed( const char* name );
	// Invoke platform specific implementation to inform the system of another
	// place to look for Lua code.  On Mac/iOS this means it will look for
	// a framework by this name (plus ".framework") in the app bundle (iOS) or
	// frameworks directory (Mac).  If the system detects the umbrella
	// framework "WichitaFoundation.framework" then it will look inside that
	// framework for subframeworks.
	// On windows, this adds another .dll to look for resources in.
	// etc...
	// It is valid to pass NULL for name, which signals that the main bundle,
	// or main .exe should be consulted for lua files, too.

//------------------------------------------------------------------------------

void ksl_addPackagePath( const char* path );
	// This path can be used to override the default package.path variable
	// for all Lua universes created in the future, except for those created
	// via initWithMinimalState.
	
	// ksl_setDefaultPackagePath makes a copy of the string that it
	// receives.


//------------------------------------------------------------------------------

WF_API void ksl_addPackageLoaders( luaL_Reg* packageLoaders );
	// Add one or more package loaders to all Lua universes that get created
	// in the future, except for those created via initWithMinimalState.
	// While not recommended, it is not an error to specify the same package
	// name twice. The last one registered wins. The list is terminated by
	// a luaL_Reg structure with a NULL name. The list is not copied and hence
	// should exist as a static value.

//------------------------------------------------------------------------------

void ksl_addLuaInitializers( luaL_Reg* initializers );
	// Add one or more functions to the list of Lua universe initializers.
	// These functions get called during the spin-up process for all Lua universes
	// that get created in the future, except for those created via
	// initWithMinimalState. The names in this list are purely informational.
	// The order in which these initializer functions get called is not specified.
	// The list is terminated by a luaL_Reg structure with a NULL name. The
	// list is not copied and hence should exist as a static value.

//------------------------------------------------------------------------------

#endif
