/*******************************************************************************

KSLuaObjCExceptionBridge.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2010 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

	// Cocoa
#import <Foundation/Foundation.h>

	// Lua 5.1
#import <AgKernel/lua.h>

//------------------------------------------------------------------------------
/*
	IOS4_SPAM [scouten 2010-09-22]: There is the possibility that Lua errors are
	thrown from within this block and that violates a rule of the Objective-C
	error system (setjmp/longjmp should not cross a @try block boundary). For now
	we are simply living with that possibility, although this macro set is written
	to avoid that case. In iOS 4, we may be able to alleviate that possibility
	by wrapping in an Objective-C block and using pcall.
	
	For now, any Objective-C code (i.e. any code that might throw Obj-C exceptions)
	that is directly called from Lua should be wrapped in the following sequence:
	
	@try {
		// Do stuff in Objective-C.
	}
	KSL_CATCH_OBJECTIVE_C_ERROR_FOR_LUA( L )
	
	FIXME [scouten 2010-11-09]: Revisit this now that exception marshaling has changed.
	
	---- [mhamburg 2010-11-03]: This is indeed almost certainly a problem.
	Competing exception stacks only get partially unwound. We need to come up
	with a real solution -- preferably soon.
	
	---- [scouten 2010-11-03]: Assuming either my patch or something similar
	is accepted, then we will have changed Lua error handling to be using
	Objective-C exceptions, at least for those universes that are built using
	KSLuaUniverse. (Other universes really should not interact with Objective-C
	code in a tight fashion if at all.)

	---- [scouten 2010-11-03]: We probably should simply remove this macro
	and the function below completely. Leaving in now so we can discuss tomorrow
	(and pending Mark's possible rewrite of the new exception handling code).
*/
	
#define KSL_CATCH_OBJECTIVE_C_ERROR_FOR_LUA( L ) \
	@catch( id error ) { \
		kslobjc_raiseLuaErrorFromCocoaException( L, error ); \
	}
	
//------------------------------------------------------------------------------

void kslobjc_raiseLuaErrorFromCocoaException( lua_State* L, id error );
	// Intended for use from above macro. Does not return.
	// Takes any Objective-C object (including nil) and turns it
	// into a Lua error.
