/*******************************************************************************

KSObjCUtils.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2007 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#import "KSMacros.h"

//------------------------------------------------------------------------------

void KSObjC_releaseOnMainThread( id object );
	// Do a release on the main thread. If we're already on the mean thread,
	// this will just do that release. If we aren't, then it will use the
	// appropriate dispatch logic to do so.
	
//------------------------------------------------------------------------------

#define KSReleaseOnMainThreadAndClear( fieldName ) KSStatementBlock( KSObjC_releaseOnMainThread( fieldName ); fieldName = nil; )
	// Send release to a field (or less commonly a variable) and then clear it to
	// nil. Useful in dealloc methods. This will actually use KSObjC_releaseOnMainThread
	// so that one can use it with objects that have to be dealloc'd on the
	// main thread and hence should probably be released there as well.
