/*******************************************************************************

KSUserdataProxy.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2010 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

********************************************************************************

Lua offers the undocumented newproxy function for creating userdata proxies.
It has complicated semantics and still doesn't do quite what one wants. This
module introduces a package called proxy that has one function for making
a proxy factory:

	factory, test, check, opt, mt = KSUserdataProxy.makeFactory( [ optname ] )
	
The metatable returned is empty but should be filled in before invoking the
factory:

	ud [ , env ] = factory( [ env ] )
	
This function returns the environment (a table) if supplied. Otherwise,
the environment value is kept at the default value and hidden.

The test function returns true if the supplied value is an appropriate
userdata proxy and returns the environment if one was supplied. It returns
false otherwise:

	proxy, env = test( value )

The check function can be used to check that a userdata is a proxy of the
right sort and to recover its environment. It throws if the value is
of the wrong type. If no environment was supplied on construction, none
is returned.

	proxy, env = check( value )
	
The opt function is like check, but accepts nil as an argument and an optional
default value for the environment. proxy will always be equal to value, so
passing nil will return nil for the first value. (We generally rely on it
throwing in the unsuccessful cases.) Note that passing no arguments results
in no results.

	proxy, env = opt( value [ , defaultEnv ] )
	
Userdata proxies are faster and more secure than proxies based on empty tables.

*******************************************************************************/

#ifndef KSUserdataProxy_h
#define KSUserdataProxy_h

#include <AgKernel/lua.h>

//==============================================================================

int KSUserdataProxy_createNamespace( lua_State* L );

//==============================================================================

#endif /* KSUserdataProxy_h */
