/*******************************************************************************

NSData+KSDataCocoa.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2011 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

	// Cocoa
#import <Foundation/NSData.h>

	// Lua
#import <AgKernel/lua.h>


//==============================================================================
/*
	The Cocoa implementation of the KSData API uses NSData under the hood.
	These API extensions give you access to that mapping.
*/

//------------------------------------------------------------------------------

@interface NSData( KSDataCocoa )

+ (NSData*) ks_dataFromLuaState: (lua_State*) L atIndex: (int) index;
	// Convert the value on the stack at the specified index to an NSData.
	// Only works if this is a KSData object.

+ (NSData*) ks_dataFromLuaState: (lua_State*) L atIndex: (int) index
					orString: (BOOL) alsoAcceptLuaString;
	// Convert the value on the stack at the specified index to an NSData.
	// If alsoAcceptLuaString is set to YES, then this will work for either
	// Lua string or KSData object. In the string case, may be slightly less
	// efficient since it will have to construct an NSData object.

+ (NSData*) ks_dataFromLuaState: (lua_State*) L tableIndex: (int) index field: (NSString*) fieldName;
	// Convert the field in the table on the stack at the specified index to an NSData.
	// This does not work for String objects : They must be KSData only.

- (void) ksdata_pushToLuaState: (lua_State*) L;
	// Push a reference to this data onto the Lua state. This data can be
	// accessed via the C-style KS* APIs declared in KSData.h.

@end
