/*******************************************************************************

NSDateFormatter+KSIso8601Dates.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#import <Foundation/Foundation.h>

//------------------------------------------------------------------------------

@interface NSDateFormatter( KSIso8601Dates )

+ (NSDateFormatter*) ks_createIso8601DateFormatter;

	// Returns an NSDateFormatter that has been configured for parsing
	// ISO 8601 input strings into NSDates using - dateForString: (NSString*)
	//
	// - NSDateFormatters normally default to the user's locale.
	//  Its locale is set to en_us_POSIX, which ensures support for a gregorian
	//  calendar, 24 hour time, etc. (See Apple's documentation on configuring
	//  NSDateFormatters for parsing strict-format dates:
	//	https://developer.apple.com/library/ios/#qa/qa1480/_index.html )
	//
	// - Its format is set to "yyyy-MM-dd'T'HH:mm:ss"


+ (NSDateFormatter*) ks_iso8601DateFormatter;

	// This one holds onto the formatter in a static so it can be reusued
	// without construction overhead.

@end

//------------------------------------------------------------------------------
