/*******************************************************************************

NSString+KSLuaUtils.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2010 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

	// Cocoa
#import <Foundation/NSString.h>

	// Lua
#import <AgKernel/lua.h>


//==============================================================================

// Helpers to map NSString to Lua strings.

@interface NSString( KSLuaUtils )

//------------------------------------------------------------------------------

+ (NSString*) ks_stringFromLuaState: (lua_State*) L atIndex: (int) index
					usingToString: (BOOL) usingToString;

	// Convert the value on the stack at the specified index to an NSString.
	// If usingToString is YES, then we call tostring() on the value before
	// conversion. Stack contents are unaffected by this call.

//------------------------------------------------------------------------------

+ (NSString*) ks_stringFromLuaState: (lua_State*) L atIndex: (int) index;

	// Convert the value on the stack at the specified index to an NSString.
	// This form is faster than the earlier version because it does not call tostring().
	// However, if the value at this stack index is not already a string, it
	// simply returns nil.

//------------------------------------------------------------------------------

+ (NSString*) ks_stringFromLuaState: (lua_State*) L tableIndex: (int) index field: (NSString*) fieldName;

	// Fetch a field from the table on the stack at the specified index and return
	// it as an NSString.  This does not call tostring() on the argument.
	// However, if the value at in the table is not a string, it
	// simply returns nil.

//------------------------------------------------------------------------------

@end
