/*******************************************************************************

StCriticalSectionLock.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifndef StCriticalSectionLock_h
#define StCriticalSectionLock_h

#ifdef _PTHREAD_H_
#define CS pthread_mutex_t
#define ENTER pthread_mutex_lock
#define LEAVE pthread_mutex_unlock
#else
#include <Windows.h>

#define CS CRITICAL_SECTION
#define ENTER EnterCriticalSection
#define LEAVE LeaveCriticalSection
#endif


//==============================================================================

class StCriticalSectionLock {

private:
	CS* _criticalSection;
	
public:
	StCriticalSectionLock( CS* criticalSection ) : _criticalSection( criticalSection ) {
		
		ENTER( _criticalSection );
		
	}
	
	~StCriticalSectionLock() {
		
		LEAVE( _criticalSection );
		
	}
	
};

#endif // StCriticalSectionLock_h
