/*******************************************************************************
 
StRestoreStackContents.h
 
********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#pragma once

	//third_party/lua_tp/lua_5_1/src
#include <AgKernel/lua.h>


//==============================================================================

#pragma mark StRestoreStackContents

/**
	Wrapper class that restores a Lua state to its existing state (# items).
	Was: StRestoreStackContents.
*/

//------------------------------------------------------------------------------

class StRestoreStackContents

{

public:

	//--------------------------------------------------------------------------

	StRestoreStackContents( lua_State* L ) : fState( L )
	{
		fOldTop = lua_gettop( L );
	};

	//--------------------------------------------------------------------------

	~StRestoreStackContents()
	{
		lua_settop( fState, fOldTop );
	};

private:

	//--------------------------------------------------------------------------

	lua_State* fState;
		/**< the state whose contents we're restoring */

	int fOldTop;
		/**< lua_gettop() at start of the scope */

};
