/*******************************************************************************

WFApiDefs.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifndef WFApiDefs_h
#define WFApiDefs_h

/*!
	\file WFApiDefs.h

	\brief Macros for defining public API functions.
*/

	// Kernel
#include <AgKernel/AgAPIDefs.h>


//==============================================================================
/**
	\brief Prefix for all public WF functions.

	This prefix causes the function to be marked for DLL export as as an
	<code>extern "C"</code> function.

	For functions that must be in C++ or C++/CX, use \c WF_EXPORT instead.
*/

#define WF_API AgAPI

//------------------------------------------------------------------------------
/**
	\brief Prefix for public WF functions that require C++ linkage.

	Use this prefix ONLY when exporting platform-specific C++ (including C++/CX) functions.

	This prefix causes the function to be marked for DLL export, but without
	the <code>extern "C"</code> modifier.
*/

#define WF_EXPORT AgExport

//------------------------------------------------------------------------------

#endif
