/*******************************************************************************

WFAppMemoryUsage.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

********************************************************************************/

/*!
	\file WFAppMemoryUsage.h
 
	\brief Debug instrumentation utility which provides data about the process's
			current and peak memory consumption. Currently only supported on Cocoa platforms.
 */

// FIXME [epoley 2012-08-28]: WFAppMemoryUsage is not yet supported on WinRT
// because we have not yet found a utility that will allow us to sample the memory
// usage for the process.

#if MAC_ENV || IOS_ENV

typedef void (^WFAppMemoryUsage_callbackBlock)( size_t, size_t, size_t, size_t );

void WFAppMemoryUsage_getCurrentUsage( size_t *vMem, size_t *rMem );
	/**<
	
	 \brief Reports the virtual and resident memory currently in use by the process.
	
	*/

void WFAppMemoryUsage_startPolling( void );
	/**<
	 
	 \brief	Starts polling of the current memory usage on an interval, in order to monitor
		maximum values. Polling is optional; it's perfectly valid to call
		\c WFAppMemoryUsage_getCurrentUsage() without enabling polling.
	 
		There is no harm in calling \c WFAppMemoryUsage_startPolling() more than once.
		In fact, each thread that expects to use \c WFAppMemoryUsage_getPeakUsage() or
		\c WFAppMemoryUsage_registerCallback() should first start polling to
		ensure consitent results.
	 
	 */

void WFAppMemoryUsage_getPeakUsage( size_t *vMem, size_t *rMem );
	/**<
	 
	 \brief Reports the peak memory usage since \c WFAppMemoryUsage_startPolling() was called.
		(Otherwise, zero.) To ensure reliable results, \c WFAppMemoryUsage_startPolling()
		should have already been called from the same thread before calling
		\c WFAppMemoryUsage_getPeakUsage().
	 
	 */

void WFAppMemoryUsage_registerCallback( WFAppMemoryUsage_callbackBlock callbackBlock );

	/**<
	 
	 \brief Allows clients to register a callback block to be notified of memory consumption values
		on the polling interval.
	 
	 */

#endif
