//==============================================================================
//
//  WFCapabilities.h
//
//==============================================================================
//
//	ADOBE CONFIDENTIAL
//	------------------
//	Copyright 2013 Adobe Systems Incorporated
//	All Rights Reserved.
//
//	NOTICE: All information contained herein is, and remains the property of
//	Adobe Systems Incorporated and its suppliers, if any. The intellectual and
//	technical concepts contained herein are proprietary to Adobe Systems
//	Incorporated and its suppliers and are protected by all applicable
//	intellectual property laws, including trade secret and copyright laws.
//	Dissemination of this information or reproduction of this material is
//	strictly forbidden unless prior written permission is obtained from
//	Adobe Systems Incorporated.
//
//==============================================================================

#ifndef WFCapabilities_h
#define WFCapabilities_h

#include <WFCore/WFAPIDefs.h>


//==============================================================================
/*!
	\file WFCapabilities.h

	\brief A "C" API for accessing the WFCapabilities key/value store.
*/


//==============================================================================
/*!
	\brief Set a capability.
	
	\param key The string key to set. Must be non-NULL.
	
	\param value The value to set. If NULL, it removes the key entry.

	\return success (int) Returns non-zero if the values was successfully set.
*/


WF_API int WFCapabilities_setCapability( const char* key, const char* value )
		#ifdef __clang__
			// Help avoid accidentally passing in invalid key.
			__attribute__( ( nonnull( 1 ) ) )
		#endif
	;

//==============================================================================
/*!
	\brief Get a capability.
	
	\param key The string key to get. Must be non-NULL.

	\return value (const char*) Returns the value corresponding to the key
*/


WF_API const char* WFCapabilities_getCapability( const char* key )
		#ifdef __clang__
			// Help avoid accidentally passing in invalid key.
			__attribute__( ( nonnull( 1 ) ) )
		#endif
	;


//------------------------------------------------------------------------------
/*!
	\brief Add a function to run whenever a value is produced internally for
	a particular filter id.
	
	The clientId is used to allow a client to replace a filter that has been already
	registered. Only one filter is retained for each combination of selector and
	clientId.
	
	The filter is provided as a string which is looked up via require. This is
	done because a filter may run on any message processor.
	
	To avoid race conditions, one should normally register all filters early in
	launch prior to creating additional message processors.
	
	\param selector The selector.
	\param clientId The unique client ID.
	\param namespaceFunc A namespace name and function as a single string containing
		a single period. For example "MyNamespace.myFunction". Whenever a value
		needs filtering, your function will be called.

	\return success (int) Returns non-zero if the values was successfully set.
*/

WF_API int WFCapabilities_addFilter( const char* selector,
									 const char* clientId,
									 const char* value )
		#ifdef __clang__
			// Help avoid accidentally passing in invalid key.
			__attribute__( ( nonnull( 1, 2 ) ) )
		#endif
	;

//------------------------------------------------------------------------------

#endif
