/*******************************************************************************

WFCommandManager.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

/*!
 \file WFCommandManager.h
 
 \brief \c WFCommandManager allows native code to check the status of Lua commands.
 Lua command state is tied to the KSLVC event processor, and changes to state are
 sent over to the main dispatcher.  This ensures that these APIs return immediately,
 without need to roundtrip across threads for data.
 */

#ifndef WFCommandManager_h
#define WFCommandManager_h

#if IOS_ENV || MAC_ENV
#include <stdbool.h>
#elif WIN_ENV || WINRT_ENV || ANDROID_ENV
#include <WFCore/WFApiDefs.h>
#include <WFCore/KSLua.h>
#include <functional>
#endif


//==============================================================================

#pragma mark -
#pragma mark Cross-platform APIs

//------------------------------------------------------------------------------

bool WFCommandManager_isCommandRegistered( const char* commandName );
	/**<
		\brief Checks to see if the specified command is registered.

		\threadsafety Should only be called on the main thread.
	 
		\param commandName the command to look up
	 
		\return true if the named command has been registered, otherwise false.
	*/

bool WFCommandManager_canExecuteCommand( const char* commandName );
	/**<
		\brief Checks to see if the specified command can be executed.

		\threadsafety Should only be called on the main thread.
	 
		\param commandName the command to look up
	 
		\return true if the named command has been registered and can be executed,
		otherwise false.
	*/

//------------------------------------------------------------------------------

#pragma mark -
#pragma mark iOS/Mac-specific APIs

//------------------------------------------------------------------------------

#if IOS_ENV || MAC_ENV

//------------------------------------------------------------------------------

void WFCommandManager_executeCommand( NSString* commandName, NSArray* optNSStringArray );
	/**<
		\brief Executes the specified command.

		\param commandName the command to execute
	 
		\param optNSStringArray an optional array of strings to pass to the command
	*/

#elif (WINRT_ENV || ANDROID_ENV)

//------------------------------------------------------------------------------

// - renaming to WFCommandManager_executeCommand_stdc, because the signature is slightly different.

WF_API void WFCommandManager_executeCommand_stdc( const char* commandName, std::function<int (lua_State* L)> optPushParamsF = nullptr );
	/**<
		\brief Executes the specified command.
		\param commandName the command to execute
		\param optPushParamsF an optional function that pushes the arguments to lua.  (Note thi
			function is executed on another thread.)
	*/

#endif // WIN_ENV || WINRT_ENV

//------------------------------------------------------------------------------

#endif // WFCommandManager_h
