/*******************************************************************************

WFConfiguration.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

/*!
	\file WFConfiguration.h

	\brief \c WFConfiguration is the gatekeeper for the Lua configuration file, \c config.lua, which lets
	you configure your application on the fly.

	Use this API to configure Boolean flags that you can check from C code
	(including Obj-C and C++). The file \c KrConfiguration.lua exposes the contents of
	the \c config.lua file to the Lua universe.


 	A Lua configuration flag must be in a configuration namespace,
	which is a table that's automatically created for you for any
	flag you set. Here's an example of a line  in the Lua configuration file:

	\verbatim
	MyModule.MyFlag = 42
	\endverbatim

	You can check that flag from your code like this:

	\verbatim
	if WFConfiguration.MyModule.MyFlag == 42 then
		-- We have the answer!
	end
	\endverbatim
*/

#include <AgKernel/AgAPIDefs.h>

#ifndef WFConfiguration_h
#define WFConfiguration_h

AgBeginExternC

//------------------------------------------------------------------------------
/*!
	\brief 	Defines native flags in \c WFConfigurationFlag structure.
	By default, contains a placeholder for end-of-list.

	To create a new native flag, add it to the \c ENTRIES definition like this:

	\verbatim
	FLAG( MyConfigureFlag ),
	\endverbatim

	You can then add a line like this to your Lua configuration file:
	\verbatim
	nativeSwitches.MyConfigureFlag = true
	\endverbatim

	In your native code, check the status of that flag like this:
	\verbatim
	WFConfiguration_isEnabled( WFConfiguration_MyConfigureFlag );
	\endverbatim
*/
#define ENTRIES \
FLAG( SampleConfigFlag )

//------------------------------------------------------------------------------
/*!
	\brief Defines a native flag in the \c ENTRIES list.
*/
#define FLAG( x ) \
WFConfiguration_ ## x,

//------------------------------------------------------------------------------
/*!
	\brief Configuration flags that are exposed to native code. Add new flags to the \c ENTRIES list
*/
enum WFConfigurationFlag {

	WFConfiguration_Unused = -1,

	ENTRIES

};

typedef enum WFConfigurationFlag WFConfigurationFlag;

#undef FLAG

//------------------------------------------------------------------------------
/*!
	\brief Reports the state of a configuration flag.

	\param flag The flag to query.

	\return A pointer to the flag's current state.

	\todo Why is this returning a pointer instead of the value?
*/

AgAPI AgBool* WFConfiguration_isEnabled( WFConfigurationFlag flag );

//------------------------------------------------------------------------------

AgEndExternC

#endif
