/*******************************************************************************

WFCoreInit.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2011 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

/*!
	\file WFCoreInit.h

	\brief \c WFCoreInit provides the core mechanism for starting up the
	Wichita Foundation core.
*/

#ifndef WFCoreInit_h
#define WFCoreInit_h

	// wichitafoundation/core
#include "WFApiDefs.h"

	// kernel
#include <AgKernel/AgLuaState.h>

#if ANDROID_ENV

	// Android specifics
#include <WFCore/WFCoreInitAndroid.h>

#endif


//==============================================================================

typedef KrDebuggerPtr( *ExternalDebuggerFetcher)( void );

/*!
	\brief These values customize the way WF is integrated with your application.
	 Provide alternative function pointers and settings in
	 the table you pass to \c WFCore_initialize() to change the default behavior.
 */
typedef struct {
	/*!	When true (1, the default), initializes the Lua Kernel framework at the same time.  */
	int	initAgKernel;
	/*!	When true (1, the default), WF sets the AgKernel code runner to support debugger code injection into its universes.  */
	int	setCodeRunner;
	/*!	If provided, uses the supplied function to create a \c KrDebugger instance. Otherwise, creates a default debugger instance.  */
	ExternalDebuggerFetcher debuggerFetcher;
	/*!	When true, adds an entry to package.loaders so that chunk names for breakpoints, and other debugging
	features are altered to be compatible with the Halide debugger.  */
	int installStockPackageLoader;
	/*! The name to use for the app data dir on Win32 */
	const char* appDataDirName;
	/*! The default resource name to use in keychain entries */
	const char* keychainResourceName;
	/*!	When true (1, the default), initializes the Lua Kernel framework at the same time.  */
	int distributionBehavior;
    /*! If provided, uses the port to connect to Halide. Otherwise falls back to 11111. */
    const char* debugPort;

} WFCore_initialization_settings;

//==============================================================================

WF_API int WFCore_isDistribution( void );

//==============================================================================
/*!
	\brief Initializes the Wichita Foundation core library.

	Call once, before any other functions in WF core.
	Any subsequent calls are ignored. After this call, you can initialize all other modules.

	\param optSettings An optional pointer to a \c WFCore_initialization_settings
	table that specifies customized behavior for WFCore. If not supplied, defaults
	are used for all settings.
 */

WF_API void WFCore_initialize( WFCore_initialization_settings *optSettings );

//------------------------------------------------------------------------------
/*!
	\brief Is the Wichita Foundation core library initialized?
	
	\return true if the library is initialized
 */

WF_API int WFCore_isInitialized( void );

//------------------------------------------------------------------------------
/*!
	\brief Retrieves a pointer to the debugger instance.

	In non-debug (shipping or distribution) build configurations, this pointer is \c NULL.
*/

WF_API KrDebuggerPtr WFCore_getAgKernelDebugger( void );

//------------------------------------------------------------------------------

#if WIN_ENV || WINRT_ENV || ANDROID_ENV

/*!
	\brief Creates the main Lua universe for a session.	A universe is a set of Lua data
	structures and their state, accessed in a single thread.

	\param optInitFile Optional, a Lua initialization file for the universe,
	for bootstrapping the Windows client only. (This will
	go away once WF messaging and event processors are online on Windows.)

	\return The Lua state of the new universe.
*/

WF_API lua_State* WFCore_createMainUniverse( const char* optInitFile );

#endif

//------------------------------------------------------------------------------
/*!
	\brief Shuts down the Wichita Foundation core library.

	Not required, but allows WF to release resources before app shutdown.
*/

WF_API void WFCore_shutdown( void );

//------------------------------------------------------------------------------
/*!
	\brief Retrieves the number of seconds since \c WFCore_initialize() was called.
*/

WF_API double WFCore_timeIntervalSinceAppLaunch( void );


//------------------------------------------------------------------------------

/*!
	\brief Retrieves the application data dir name.  This is not the full path and applies to
	Win32 only.
*/

WF_API const char* WFCore_appDataDirName( void );

//------------------------------------------------------------------------------
/*!
	\brief Retrieves the base resource name to use for keychain/credential manager entries.
*/

WF_API const char* WFCore_keychainResourceName( void );


//------------------------------------------------------------------------------

#endif
