/*******************************************************************************

WFDigest.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#include <AgKernel/lua.h>

#if WIN_ENV
#include <openssl/engine.h>

typedef const EVP_MD * (*DigestEVPType)( void );

#elif WINRT_ENV

typedef const wchar_t * DigestEVPType;

#elif MAC_ENV || IOS_ENV

#include <CommonCrypto/CommonHMAC.h>

typedef CCHmacAlgorithm DigestEVPType;

#elif ANDROID_ENV

typedef const char * DigestEVPType;

#endif

struct LuaStateOrDigestContext {
	union {
		lua_State* L;
		unsigned char data[ 1 ];
	};
};

typedef struct LuaStateOrDigestContext * GenericStructPointer;
typedef int (*DigestInitCleanupFnPtr)( GenericStructPointer c );
typedef int (*DigestUpdateFnPtr)( GenericStructPointer c, const void *data, size_t len );
typedef int (*DigestFinalFnPtr)( const unsigned char *d, GenericStructPointer c );
typedef int (*DigestDuplicateFnPtr)( GenericStructPointer dest, const GenericStructPointer src );
typedef struct digest_impls {
	const char *name;
	size_t context_size;
	DigestInitCleanupFnPtr init;
	DigestUpdateFnPtr update;
	DigestFinalFnPtr final;
	DigestInitCleanupFnPtr reset;
	DigestInitCleanupFnPtr cleanup;
	DigestInitCleanupFnPtr getLength;
	DigestEVPType mp;
	size_t	length;
} DigestFuncInfo;

/**
	\brief get a DigestFuncInfo struct containing necessary functions to
	do a digest operation on data.  To do a digest, first allocate a context
	of f->context_size and init it to all zeroes.  Then call f->init passing
	in context.  Then call f->update, passing in the context, a pointer to your
	data and a size.  Repeat update as many times as you want.  Then get
	the digest by calling f->final, passing in a pointer to a buffer that you've
	allocated and zeroed out of size f->length, and also pass in the context.
	When you're done call f->cleanup (if non-NULL) passing in the context.  Don't
	forget to free the context and any result buffer you allocated.
	
	\param digest the name of the digest to get
	\param outInfo a pointer to a pointer to store the result.  If no such digest
		is found, it will be NULL.
*/
WF_API void WFDigest_getDigestFuncInfo( const char * digest, DigestFuncInfo** outInfo );

/**
	\brief push a digest in two forms to lua: first it pushes a friendly
	hexidecimal form; next it pushes the binary form.

	\param L the lua state to push to
	\param result the digest in binary representation.  This buffer will be
	re-written in-place with the hex form as a side-effect of calling this routine.
	\param length the length of the digest
	\param bufferSize The size of memory allocated at result.  It must be length*2 + 1
		bytes or greater, or this routine will fail.
	
	\return the number of results pushed.  Will return zero in the event of error.
	*/
int WFDigest_pushDigestToLuaL( lua_State*L, unsigned char *result, size_t length, size_t bufferSize );

//==================================================================
