/*******************************************************************************

WFFileUtils.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

********************************************************************************

Support for representing native StorageFolder^ types in Lua

*******************************************************************************/

#include <AgKernel/AgLua.h>
#include <WFCore/WFApiDefs.h>

#ifndef WINRT_ENV
typedef enum {
	WFFileUtils_CollisionOption_GenerateUniqueName,
	WFFileUtils_CollisionOption_ReplaceExisting,
	WFFileUtils_CollisionOption_FailIfExists,
	WFFileUtils_CollisionOption_OpenIfExists,
} WFFileUtils_CollisionOption;

#else

typedef enum {
	WFFileUtils_CollisionOption_GenerateUniqueName = Windows::Storage::CreationCollisionOption::GenerateUniqueName,
	WFFileUtils_CollisionOption_ReplaceExisting = Windows::Storage::CreationCollisionOption::ReplaceExisting,
	WFFileUtils_CollisionOption_FailIfExists = Windows::Storage::CreationCollisionOption::FailIfExists,
	WFFileUtils_CollisionOption_OpenIfExists = Windows::Storage::CreationCollisionOption::OpenIfExists,
} WFFileUtils_CollisionOption;

// I don't see the point in exporting both the Creation Collision Option
// AND the Name Collision Option enums independently.  Creation options are
// a superset of name, so I can use that for both in our lua bridging.
// However, to make sure Win8 doesn't pull a fast one, let's ensure
// that this assumption is valid.  So long as these asserts pass
// we are okay to cast the int result from WFFileUtils_optCollisionOption_L to
// either type.

static_assert( (int) Windows::Storage::NameCollisionOption::GenerateUniqueName == (int) Windows::Storage::CreationCollisionOption::GenerateUniqueName, "Name and Creation option GenerateUniqueName aren't equal" );
static_assert( (int) Windows::Storage::NameCollisionOption::ReplaceExisting == (int) Windows::Storage::CreationCollisionOption::ReplaceExisting, "Name and Creation option GenerateUniqueName aren't equal" );
static_assert( (int) Windows::Storage::NameCollisionOption::FailIfExists == (int) Windows::Storage::CreationCollisionOption::FailIfExists, "Name and Creation option GenerateUniqueName aren't equal" );

#endif

WF_API
WFFileUtils_CollisionOption WFFileUtils_optCollisionOption_L( lua_State* L, int index, WFFileUtils_CollisionOption defaultOpt );
