/*******************************************************************************

WFLuaMessagingProcessorCocoa.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

	// wichitafoundation/threading
#include "WFMessaging.h"

	// Lua 5.1
#include <AgKernel/lua.h>


//==============================================================================

typedef void (^lua_Block)( lua_State* L );

//------------------------------------------------------------------------------

bool WFLuaMessagingProcessor_scheduleBlockInLuaState( WFMessaging_ProcessorRef processor,
													  WFMessaging_EnqueueOrder enqueueOrder,
													  lua_Block block );
	/**<
		\brief Schedule a block to run in a Lua state on this messaging processor.
		
		This API does not provide any mechanism for prioritizing or canceling
		requests, nor does it provide any mechanism for the caller to receive
		results.
		
		\warning The effect of calling this when \c processor is not a Lua-provisioned
		message processor are undefined.
		
		\threadsafety This function may be called from any thread.
		
		\param processor the worker processor (thread) that is expected
			to respond to the request. Must be a Lua-provisioned message processor.
		\param enqueueOrder the queue position to use when scheduling
		\param block the block to be called
		
		\return \c true if this message was successfully enqueued for processing;
			\c false if not. (A \c false return might occur, for example, if
			the message handler for this processor has been terminated.)
	*/
