/*******************************************************************************

WFLuaPackageLoader.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

/*!
	\file WFLuaPackageLoader.h

	\brief \c WFLuaPackageLoader provides a platform-generic interface for
	configuring Lua's package loader.
*/

#ifndef WFLuaPackageLoader_h
#define WFLuaPackageLoader_h

	// Lua
#include <AgKernel/lua.h>

#include "WFApiDefs.h"

//------------------------------------------------------------------------------

#if ANDROID_ENV
WF_API
#endif
const char* WFLuaPackage_luaPackagePaths( void );
	/**<
		\brief Retrieves the a semicolon delimited list of paths for loading Lua scripts.

		This string is a global that does not change during the life of the
		application. The caller should not free the string.
	*/

//------------------------------------------------------------------------------

WF_API int WFCore_loadFile( lua_State* L, const char* filePath );
WF_API int WFCore_loadLuaAsResource( lua_State* L, const char* filePath );
	/**<
		\brief Loads a script into a Lua state.

		Use this instead of \c luaL_loadbuffer, in order to	configure the script
		with the path information that the Halide debugger requires.

		\param L The Lua state.
		\param filePath The file path of the script, relative to \c WFLuaPackage_luaPathPrefix().

		\return A Lua error code, 0 on success, or \c LUA_ERRRUN if the script is not found.
	*/

//------------------------------------------------------------------------------

#endif
