/*******************************************************************************

WFLuaTestLoader.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifndef WFLuaTestLoader_h
#define WFLuaTestLoader_h

	// core
#include <WFCore/WFApiDefs.h>

// core/threading
#include <WFCore/WFMessaging.h>

	// Lua 5.1
#include <AgKernel/lua.h>


//------------------------------------------------------------------------------

WF_API int loadTestForAnalyzer_L( lua_State* L );

//------------------------------------------------------------------------------

WF_API void WFLuaTestLoader_pushTestSpec( lua_State* L );
	/**<
		\brief Push the Lua test spec reference to the Lua stack.
		
		Assumes that this is a message processor which was previously loaded
		via WFLuaTestLoader.lua. If not, simply pushes nil to the stack.
	*/

//------------------------------------------------------------------------------

WF_API void WFLuaTestLoader_pushTestLoadError( lua_State* L );
	/**<
		\brief Push any error that may have occurred while loading the Lua test
		spec to the Lua stack
		
		Assumes that this is a message processor which was previously loaded
		via WFLuaTestLoader.lua. If not, simply pushes nil to the stack.
		
		If no error occurred, pushes nil to the stack.
	*/

//------------------------------------------------------------------------------

WF_API WFMessaging_ProcessorRef WFLuaTestLoader_messagingProcessorForTestCaseAtPath(
									const char* path );
	/**<
		\brief Creates a messaging processor for the test case at the specified
			path.
		
		The message processor gains a strong reference as a result of this call.
		The caller has an obligation to release that reference by calling
		\c WFMessaging_Processor_strongRelease() when the message queue is no longer
		needed.
		
		\param path path to Lua file to load
	
		\return reference to processor object
	*/

//------------------------------------------------------------------------------

#endif
