/*******************************************************************************

WFLuaTransitData.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2011 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

/*!
	\file WFLuaTransitData.h
	
	\brief \c WFLuaTransitData provides a platform-generic interface for
	capturing values from a Lua stack for transit to another Lua state, even if
	those values may reference native objects.
*/

#ifndef WFLuaTransitData_h
#define WFLuaTransitData_h

	// wichitafoundation/core
#include "WFApiDefs.h"

	// wichitafoundation/core/threading
#include "WFMessagingData.h"

	// Lua
#include <AgKernel/lua.h>

	// C standard library
#if MAC_ENV || IOS_ENV || ANDROID_ENV
	#include <stdbool.h>
#endif


//==============================================================================

WF_API WFMessaging_DataRef WFLuaTransitData_createFromLuaState(
                    lua_State* L, int fromIndex );
	/**<
		\brief Construct a messaging data object representing all values on the Lua
		stack starting from the specified index. Throws a Lua exception if the
        data cannot be properly encoded.
		
		\param L Lua state
		\param fromIndex stack index to start from (must be a positive integer)
		
		\return a data object that packs these values
	*/

//------------------------------------------------------------------------------

WF_API bool WFLuaTransitData_isValidTransitData( WFMessaging_DataRef dataRef );
	/**<
		\brief Returns true if the data object contains data that can be unpacked
		via \c WFLuaTransitData_unpackToLuaState().
		
		\param dataRef the data object (may be \c NULL)
		
		\return \c true if \c dataRef is non-\c NULL and represents a data object
			that was created via \c WFLuaTransitData_createFromLuaState().
	*/

//------------------------------------------------------------------------------

WF_API int WFLuaTransitData_unpackToLuaState(
                    WFMessaging_DataRef dataRef, lua_State* L );
	/**<
		\brief Unpacks the values in the data object onto the Lua stack.
		
        \param dataRef the data object (may be \c NULL, in which case no values
        will be unpacked)
		\param L Lua state
		
		\return number of new Lua values that were created
	*/

//------------------------------------------------------------------------------

#endif
