/*******************************************************************************

WFLuaTransitDataShared.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2011 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

// All platform specific routines are here.

//------------------------------------------------------------------------------

void* WFLuaTransitSupport_retainObjectForTransit( void* obj );
	// Retain an object for transit.


void WFLuaTransitSupport_releaseObjectFromTransit( void* obj );
	// Release an object from transit.

int WFLuaTransitSupport_encodeUserdataForTransit( lua_State* L,
                                     int index,
                                     int measurePass,
									 void** objectForTransit );
	// Attempt to encode a userdata object for transit. On non-measure passes,
	// the objectForTransit void* will be managed using the retain and release
	// calls above. A non-zero result indicates successful encoding.
	

void WFLuaTransitSupport_decodeUserdataFromTransit(
					lua_State* L,
                    void* objectFromTransit );
	// Decode the encoded data.


#ifdef __cplusplus
}
#endif
