/*******************************************************************************

WFMessagingImpDispatchShared.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2011 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

/*!
	\file WFMessagingImpDispatch.h
	
	\brief \c WFMessagingImpDispatch provides a wrapper around platform threading
	services.
*/

#ifndef WFMessagingImpDispatchShared_h
#define WFMessagingImpDispatchShared_h

#include "WFMessagingImpDispatch.h"
	// To check against the public definitions

//==============================================================================

#if COCOA_ENV
#pragma mark -
#pragma mark Debugging information
#endif

void WFMessagingImpDispatch_Shared_incrementObjectCountIfObject( void* obj );
	/**< \brief Increment the object counter if obj is not NULL. */

void WFMessagingImpDispatch_Shared_decrementObjectCountIfObject( void* obj );
	/**< \brief Decrement the object counter if obj is not NULL. */

//------------------------------------------------------------------------------

#if COCOA_ENV
#pragma mark -
#pragma mark Repeated declarations
#endif

// The following routines are documented and defined in WFMessagingImpDispatch.h.

size_t WFMessagingImpDispatch_totalDispatchObjects( void );

void WFMessagingImpDispatch_decrementObjectCountForPersistentGlobalObject( void );

void WFMessagingImpDispatch_Mutex_releaseAndClear(
                                WFMessagingImpDispatch_MutexRef* mutexRefPtr );

void WFMessagingImpDispatch_Queue_releaseAndClear(
                                WFMessagingImpDispatch_QueueRef* queueRefPtr );

//==============================================================================

#endif
