/*******************************************************************************

WFMessagingThreadPriorities.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

/*!
	\file WFMessagingThreadPriorities.h
	
	\brief \c WFMessagingThreadPriorities provides constants for signaling
	thread priority.
*/

#ifndef WFMessagingThreadPriorities_h
#define WFMessagingThreadPriorities_h


//------------------------------------------------------------------------------
/*!
	\brief Thread execution priority.
*/

typedef enum WFMessaging_ThreadPriority {

	wfm_tpHigh = 2,
		/**< This thread will be scheduled at high priority (i.e. typically
			 before any threads at \c wfm_tpDefault or \c wfm_tpLow priority). */

	wfm_tpDefault = 0,
		/**< This thread will be scheduled at default priority (i.e. typically
			 after any threads at \c wfm_tpHigh priority but before any threads
			 at \c wfm_tpLow priority). */
	
	wfm_tpLow = -2,
		/**< This thread will be scheduled at low priority (i.e. typically after
			 any threads at \c wfm_tpHigh or \c wfm_tpDefault priority). */
						
} WFMessaging_ThreadPriority;

//------------------------------------------------------------------------------

#endif
