//==============================================================================
//
//  WFObjCLua.h
//
//==============================================================================
//
//	ADOBE CONFIDENTIAL
//	------------------
//	Copyright 2013 Adobe Systems Incorporated
//	All Rights Reserved.
//
//	NOTICE: All information contained herein is, and remains the property of
//	Adobe Systems Incorporated and its suppliers, if any. The intellectual and
//	technical concepts contained herein are proprietary to Adobe Systems
//	Incorporated and its suppliers and are protected by all applicable
//	intellectual property laws, including trade secret and copyright laws.
//	Dissemination of this information or reproduction of this material is
//	strictly forbidden unless prior written permission is obtained from
//	Adobe Systems Incorporated.
//
//==============================================================================

#import <Foundation/Foundation.h>

#import <AgKernel/lua.h>

//------------------------------------------------------------------------------
// This category method is provided for appropriate subclasses of NSObject so
// that they get pushed to Lua in the most Lua-native way possible.  For example,
// NSString is pushed as a string, NSNull as nil, and so on.

@interface NSObject( WFObjC_LuaSupport )

- (void) wf_pushToLua: (lua_State*) L;

@end

//------------------------------------------------------------------------------

@interface NSObject( WFObjC_LuaCreation )

- (id) initWithLuaState: (lua_State*) L index: (int) index;

@end

//------------------------------------------------------------------------------
// An empty Lua table might be sent to code wanting either an empty array or
// dictionary. In order to handle these, we instead make an "empty table" object
// which is designed to act and respond like both and empty dictionary and an
// empty array (by using the ObjC runtime). This way, most client code should
// work regardless of what it expects.

@interface WFObjCEmptyTable : NSObject

+ (instancetype) emptyTable;

- (void) wf_pushToLua: (lua_State*) L;

@end

//------------------------------------------------------------------------------
// Lua-to-ObjC when pulling from stack
//------------------------------------------------------------------------------

extern NSString* WFObjC_toNSString( lua_State* L, int index );

extern NSDictionary* WFObjC_toNSDictionary( lua_State* L, int index );
extern NSArray* WFObjC_toNSArray( lua_State* L, int index );

extern NSObject* WFObjC_toNSObject( lua_State* L, int index );
	// This will use an NSDictionary or NSArray for a table based on whether
	// the table "looks like an array" (has a 1 index item). An empty table
	// will be returned as a WFObjCEmptyTable, which can be used in place of
	// either an empty table or dictionary in most respects.

//------------------------------------------------------------------------------

extern NSObject* WFObjC_toNSObjectWithMapping( lua_State* L, int index,
											   NSDictionary* customMappingClasses );

//------------------------------------------------------------------------------
