//==============================================================================
//
//  WFObjCModels.h
//
//==============================================================================
//
//	ADOBE CONFIDENTIAL
//	------------------
//	Copyright 2013 Adobe Systems Incorporated
//	All Rights Reserved.
//
//	NOTICE: All information contained herein is, and remains the property of
//	Adobe Systems Incorporated and its suppliers, if any. The intellectual and
//	technical concepts contained herein are proprietary to Adobe Systems
//	Incorporated and its suppliers and are protected by all applicable
//	intellectual property laws, including trade secret and copyright laws.
//	Dissemination of this information or reproduction of this material is
//	strictly forbidden unless prior written permission is obtained from
//	Adobe Systems Incorporated.
//
//==============================================================================

#import <Foundation/Foundation.h>

#import <WFCore/WFMessaging.h>
#import <WFCore/WFModels.h>
#import <AgKernel/lua.h>

@protocol WFModelDelegate;

//------------------------------------------------------------------------------

typedef void (^WFModelReceivedDataBlock)( id data );
typedef void (^WFModelReceivedErrorBlock)( NSString* error );
typedef void (^WFModelReceivedDoneBlock)();

//------------------------------------------------------------------------------

extern WFModels_Factory* WFObjCModels_openFactory( dispatch_queue_t clientQueue,
	WFMessaging_ProcessorRef serverProcessor );

extern WFModels_Factory* WFObjCModels_openCommonRunModesFactory(
	WFMessaging_ProcessorRef serverProcessor );

//------------------------------------------------------------------------------

@interface WFBaseModel : NSObject

+ (NSArray*) trackingModes;
+ (NSArray*) nonTrackingModes;

@property( nonatomic ) BOOL suspendUpdates;
@property( nonatomic ) NSArray* modes;

- (id) initWithFactory: (WFModels_Factory*) factory
			  selector: (NSString*) selector
				  args: (NSArray*) args;

- (id) initWithModel: (WFBaseModel*) model
			selector: (NSString*) selector
				args: (NSArray*) args;

- (id) submodel: (NSString*) selector args: (NSArray*) args;
	// An alternate, simpler way to create a submodel.

- (id) encodeData: (lua_State*) L baseIndex: (int) base;
	// Called on the server thread.  Default turns it into an NSDictionary,
	// NSArray, or other corresponding NSObject based on the type of the data.

- (void) receiveData: (id) data;
- (void) receiveError: (NSString*) error;
- (void) receiveDone;

- (void) postEvent: (NSString*) eventName args: (NSArray*) args options: (int) options;
- (void) postEvent: (NSString*) eventName args: (NSArray*) args;
- (void) postEvent: (NSString*) eventName;

	// For some subclasses:
- (void) loadWithModel: (WFBaseModel*) model
			  selector: (NSString*) selector
				  args: (NSArray*) args;

@end

//------------------------------------------------------------------------------

@interface WFModel : WFBaseModel

@property( atomic, weak ) id<WFModelDelegate> delegate;
	// a client can choose to implement the WFModelDelegate API
	
@property( ) BOOL runUntilDone;

@property( nonatomic, copy ) WFModelReceivedDataBlock onData;
@property( nonatomic, copy ) WFModelReceivedErrorBlock onError;
@property( nonatomic, copy ) WFModelReceivedDoneBlock onDone;
	// or plug in some blocks to receive data/errors/done (or both)

- (WFModel*) resolvePromiseModel: (NSString*) submodelName args: (NSArray*) args
					  onData: (WFModelReceivedDataBlock) onDataBlock;

- (WFModel*) resolvePromiseModel: (NSString*) submodelName args: (NSArray*) args
					  onData: (WFModelReceivedDataBlock) onDataBlock
					 onError: (WFModelReceivedErrorBlock) onErrorBlock;

@end

//------------------------------------------------------------------------------

@protocol WFModelDelegate <NSObject>

- (void) model: (WFModel*) model receivedData: (id) data;

@optional

- (void) model: (WFModel*) model receivedError: (NSString*) error;
- (void) modelReceivedDone: (WFModel*) model;

@end

//------------------------------------------------------------------------------

extern WFModelReceivedDataBlock WFModelAssignToProperty( NSObject* object,
														 NSString* propertyName );
	// This generates a block that has a weak reference to the object and will
	// set the property specified to the new data value whenever the data changes.

//------------------------------------------------------------------------------

extern WFModels_ClientData* WFObjCModels_createArrayClientData( NSArray* array );
	// Used internally or by subclasses, but should not be needed by clients.

//------------------------------------------------------------------------------
