/*******************************************************************************

WFRequiresARC.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2011 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/


//------------------------------------------------------------------------------
/**
	\brief Specify that an objc source file must be compiled with ARC.

	Any file that assumes ARC will create incorrect code if not compiled
	with that option turned on.  This header protects against this situation
	be emitting a preprocessor warning on any file that should have ARC
	but does not.
*/
#ifndef _WIN32
#if !ANDROID_ENV
#if __has_feature(objc_arc)

/**
	\brief Prefix for local references that must be precisely tracked by the
	reference counting mechanism (ARC) on iOS and Mac.
*/
#define WF_PRECISE_LIFETIME __attribute__((objc_precise_lifetime))

#else
#warning \
The source file that required this header needs ARC to compile.  To enable ARC \
for just this file, select the project, make sure the project is unlocked or \
changes will not be saved, select the target, select the build phases tab, open \
the compile sources stage, double click this file and add -fobjc-arc to the \
options.
#endif
#endif
#endif
