/*******************************************************************************

WFSleep.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifndef WFSleep_h
#define WFSleep_h


//==============================================================================

#if IOS_ENV || MAC_ENV || ANDROID_ENV

#include <unistd.h>
#define WFSleep( microseconds ) usleep( microseconds )

//------------------------------------------------------------------------------

#elif WIN_ENV

#include <Windows.h>
#define WFSleep( microseconds ) Sleep( microseconds / 1000 )

//------------------------------------------------------------------------------

#elif WINRT_ENV

#include "WFApiDefs.h"

WF_EXPORT void WFSleep( int microseconds );

//------------------------------------------------------------------------------

#else

#pragma error Unknown platform

#endif

//------------------------------------------------------------------------------

#endif // WFSleep_h
