/*******************************************************************************

WFStringUtils.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifndef wichitafoundation_WFStringUtils_h
#define wichitafoundation_WFStringUtils_h

#include "WFApiDefs.h"

#include <AgKernel/lua.h>

/**
	\brief Return 1 if the char, in UTF-16, is a whitespace character.  Whitespace
	includes newline, carriage return, space, tab, no-break space, and many
	others.
	
	\param c the UTF-16 character
	\return true if the character is whitespace, false otherwise.
	*/
WF_API
int WFStringUtils_isWhiteSpace( unsigned short c );

/**
	\brief Return 1 if the char, in UTF-16, is a comma. There are a few different
	commas, including 002C (COMMA), 3001 (IDEOGRAPHIC COMMA) and FF0C (FULLWIDTH COMMA).
	
	\param c the UTF-16 character
	\return true if the character is a comma, false otherwise.
	*/
WF_API
int WFStringUtils_isCommaCharacter( unsigned short c );

/**
	\brief Return 1 if the char, in UTF-16, is a dash, or similar to a dash. These
	are not considered word break chars.
	
	\param c the UTF-16 character
	\return true if the character is a dash, false otherwise.
	*/
WF_API
int WFStringUtils_isDashlikeChar( unsigned short c );

/**
	\brief Return 1 if the char, in UTF-16, is a word separator.
	
	\param c the UTF-16 character
	\return true if the character is a word separator, false otherwise.
	*/
WF_API
int WFStringUtils_isWordSeparatorForSearchParsing( unsigned short c );

// Base64 utils accessible from native code. The char* returned is assigned memory by these routines
// and callers should use the releaseBase64 method to free once they're done.

WF_API size_t encodeBase64 ( const char* srcData, size_t size, char** base64string );
WF_API size_t decodeBase64 ( const unsigned char* string, size_t size, char** decodedString );
WF_API void releaseBase64( char* );

WF_API
int decodeBase64_L( lua_State* L );

WF_API
int encodeBase64_L( lua_State* L );


#endif
