/*******************************************************************************

WFVarArgs.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2011 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

********************************************************************************

This module provides support for processing Lua varargs constructs more
efficiently than making repeated calls to select.

	function WFVarArgs.map( fn, ... )
		Applies fn to each element of ... expecting one value back for all
		but the last element where it supports an arbitrary number of values.
		
	function WFVarArgs.foldl( fn, accum, ... )
		Folds each o the elements of ... into the accumulator one at a time
		by evaluating accum = fn( accum, x ). Proceeds from left to right.
		Returns the resulting accumulated value.

	function WFVarArgs.findFirst( pred, ... )
		Find the first argument for which pred returns true and return it.
		Returns nothing if no arguments succeed for pred.

*******************************************************************************/

#ifndef WFVarArgs_h
#define WFVarArgs_h

#include <AgKernel/lua.h>

//==============================================================================

int WFVarArgs_createNamespace( lua_State* L );

//==============================================================================

#endif /* WFVarArgs_h */
