/*******************************************************************************

WFWallTimer.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifndef WFWallTimer_h
#define WFWallTimer_h

//==============================================================================


#if  WINRT_ENV

#include <chrono>
typedef std::chrono::high_resolution_clock::time_point WFTimePoint;

#elif WIN_ENV

#include <Windows.h>
typedef LARGE_INTEGER WFTimePoint;

#else

#include <sys/time.h>
typedef long WFTimePoint;

#endif

//------------------------------------------------------------------------------

WFTimePoint WFWallTime();

//------------------------------------------------------------------------------

long WFWallTimeElapsed( WFTimePoint startTime, WFTimePoint endTime );

#endif // WFWallTimer.h
