/*******************************************************************************

KSLuaTestCase.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2011 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

	// third_party/gh_unit_tp/classes
#import "GHAsyncTestCase.h"

#if defined(__cplusplus)
extern "C"
{
#endif
	
		// wichitafoundation/core/lua/threading
	#import <WFCore/WFLuaMessagingProcessorCocoa.h>
	
#if defined(__cplusplus)
}
#endif

//==============================================================================
/*
	Common base class for test case classes that are constructed at runtime from
	Lua files. See KSLuaTestCaseTest.lua for description on how to use this.

	This class can also be used for tests written in Objective-C that require a Lua
	state (for instance, code that sets up or configures the Lua environment).
	
	Note that this class derives from GHAsyncTestCase, even though many of our
	tests are not async. This is done so that those tests that *are* async can
	share code with the non-async tests without getting overly complicated.
	There appears to be little overhead associated with the async tracking if
	the test does not use it.
*/

@interface KSLuaTestCase : GHAsyncTestCase
{
}

//------------------------------------------------------------------------------

+ (void) registerLuaTestCases: (NSSet*) flagOptions;
	// Scan the app and register unit test classes for every "*Test.lua" file.

//------------------------------------------------------------------------------

+ (int) testCasesRegistered;
	// retruns number of lua test classes registered

//------------------------------------------------------------------------------

+ (BOOL) didRegisterSpecialCaseClass;
	// returns true if special test class is registered

//------------------------------------------------------------------------------

- (void) performBlockInTempLuaState: (lua_Block) block;

//------------------------------------------------------------------------------

- (void) runTest: (const char*) name;

//------------------------------------------------------------------------------

@end
