/*******************************************************************************

WFCoreTestsInit.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2012 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

	// wichitafoundation/core
#include <WFCore/KSLuaInitSequence.h>
#include <WFCore/WFMessagingOnce.h>

	// Lua
#include <AgKernel/lua.h>
#include <AgKernel/lauxlib.h>

//==============================================================================

#define EMIT_TEST_INIT_DECLARATION( name ) \
WF_API void name ## _initialize( void )

#define DECLARE_TEST_INIT_ROUTINE_FOR_TOOLKIT_NAMESPACES( name, globalNamespaces ) \
static void doInitializeOnce( void* pb ) { \
\
	ksl_addPackageNamed( "" #name ); \
	if( globalNamespaces ) \
		ksl_addPackageLoaders( globalNamespaces );\
\
}\
EMIT_TEST_INIT_DECLARATION( name ); \
\
EMIT_TEST_INIT_DECLARATION( name ) {\
\
	WFMessagingOnce_Decl( sInitialized );\
	WFMessagingOnce_do( &sInitialized, NULL, &doInitializeOnce );\
\
}

#define DECLARE_TEST_INIT_ROUTINE_FOR_TOOLKIT( name ) \
	DECLARE_TEST_INIT_ROUTINE_FOR_TOOLKIT_NAMESPACES( name, NULL )

#define INSTALL_TESTS_FOR_TOOLKIT( name ) \
	name ## _initialize()
