/*******************************************************************************

KSIdentityManagementUtils.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2011 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifndef KSIdentityManagementUtils_h
#define KSIdentityManagementUtils_h

#include <WFCore/WFApiDefs.h>

//------------------------------------------------------------------------------
/*!
 \brief Sets the IMS client id and secret to be used for this session. The
 implementation allows these to be set only once.
 
 \param clientId The IMS client id to use.

 \param clientSecret The IMS client secret to use.
*/

WF_API void KSIdentityManagementUtils_setImsClientIdAndSecret( const char* clientId, const char* clientSecret );

//------------------------------------------------------------------------------

#endif
