/*******************************************************************************

WFSQLiteInternal.h

********************************************************************************

ADOBE CONFIDENTIAL
------------------
Copyright 2004 Adobe Systems Incorporated
All Rights Reserved.

NOTICE: All information contained herein is, and remain the property of
Adobe Systems Incorporated and its suppliers, if any. The intellectual and
technical concepts contained herein are proprietary to Adobe Systems
Incorporated and its suppliers and may be covered by U.S. and Foreign
Patents, patents in process, and are protected by trade secret or copyright
law.  Dissemination of this information or reproduction of this material is
strictly forbidden unless prior written permission is obtained from
Adobe Systems Incorporated.

*******************************************************************************/

#ifndef WFSQLiteInternal_h
#define WFSQLiteInternal_h

#include <WFCore/WFApiDefs.h>

#include <AgKernel/AgAPIDefs.h>
#include <AgKernel/lua.h>
#include <AgKernel/AgTypes.h>

#include "sqlite3.h"

	// C standard libraries
#include <stdlib.h>


//==============================================================================

#define WFSQLite_namespace "WFSQLite"

//==============================================================================

#pragma mark WFSQLiteDatabase_callbackData

typedef struct tag_WFSQLiteDatabase_callbackData {
	lua_State* callbackState;
	int luaFuncRef;
} WFSQLiteDatabase_callbackData;

//==============================================================================

#pragma mark WFSQLiteDatabaseImp

//------------------------------------------------------------------------------

struct WFSQLiteDatabaseImp {

	sqlite3* _database;

	const char* _dbPath;				/**< debug info only */
	
	char* customStringOrder[ 1 ];		/**< string sequence used by custom_string_order collate function */

	int _errorHandlers;					/** luaL_ref for table containing error handlers */
	int64_t _changeCounter;

	// callback support
	//
	// These allow Lua code to tap into SQLite callbacks
	WFSQLiteDatabase_callbackData* progressCallback;
	WFSQLiteDatabase_callbackData* commitHook;

};

//------------------------------------------------------------------------------

typedef struct WFSQLiteDatabaseImp WFSQLiteDatabaseImp;
typedef struct WFSQLiteStatement WFSQLiteStatement;

//------------------------------------------------------------------------------
//	WFSQLiteDatabaseImp.cpp

const char* WFSQLiteDatabaseImp_toString( WFSQLiteDatabaseImp* db );

void WFSQLiteDatabaseImp_setTempL( WFSQLiteDatabaseImp* db, lua_State* L );

const char* WFSQLiteDatabaseImp_path( WFSQLiteDatabaseImp* db );

int WFSQLite_getErrorHandler( lua_State* L, WFSQLiteDatabaseImp* db, const char * field );

//------------------------------------------------------------------------------
//	WFSQLiteStatement.c

WFSQLiteStatement* WFSQLiteStatement_pushNewToLua( lua_State* L,
		sqlite3_stmt* compiledStmt, WFSQLiteDatabaseImp* db );


//------------------------------------------------------------------------------
//	WFSQLiteExceptions.c

void WFSQLite_checkError( lua_State* L, WFSQLiteDatabaseImp* db, int errCode,
					const char* dbPath, const char* statement );
	/**< You should call this function after every SQLite API call. If errCode
		 is anything other than SQLITE_OK, it asks SQLite for the textual
		 error message associated with this error and throws a corresponding
		 Lua exception. */

//------------------------------------------------------------------------------
//	WFSQLiteUtils.c
// [mhamburg 2011-03-14]: Not in our project?
// [scouten 2011-03-14]: Right.
//------------------------------------------------------------------------------
void contains_word_starting_with( sqlite3_context* context, int nArgs, sqlite3_value** args );
void contains_word_ending_with( sqlite3_context* context, int nArgs, sqlite3_value** args );
void contains_word( sqlite3_context* context, int nArgs, sqlite3_value** args );

//------------------------------------------------------------------------------
//	WFSQLiteUtils[Mac|Win].[m|cpp]
// [mhamburg 2011-03-14]: Not in our project?
// [scouten 2011-03-14]: Right.

//	Declarations of SQLite extension functions. Violating the SL
//	naming convention (intercaps) to follow the SQLite naming convention
//	(underscores).

AgExternC
int i18n_collate( void* context, int string1Length, const void* string1Raw,
					int string2Length, const void* string2Raw );

int custom_string_order( void* context, int string1Length, const void* string1Raw,
					int string2Length, const void* string2Raw );


AgExternC
int WFSQLiteMemoryInit( void );

#endif
